*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file for Nids Wave 2

* THIS IS 7th INCOME DO FILE - RELEASE DO FILE: 7 OF 7
* THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

*=====================================================================================================================================

* OPENING DATASET CREATED IN DO FILE "Income - Aggregation of post-imputation variables (6 of 7)"

*****************
*RELEASE DO FILE*
*****************

*DO FILE 7 OF 7
*THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

use "$DataOUT\hhdata.dta", clear

foreach var of varlist hhq_incb fwag cwag swag cheq prof extr bonu othe help  ///
ppen uif comp indi inhe rnt retr brid gift loan sale remt plot opro {
rename `var'_data `var'_flg
}

keep pid w2_hhid hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag_imp cwag_imp swag_imp ///
cheq_imp prof_imp extr_imp bonu_imp othe_imp help_imp plot_imp opro_imp spen ppen_imp uif comp_imp dis ///
chld fost cdep indi_imp inhe_imp rnt_imp retr_imp brid_imp gift_imp loan_imp sale_imp remt_imp fwag_flg ///
cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg ///
dis_flg chld_flg fost_flg cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg ///
remt_flg plot_flg opro_flg
sort w2_hhid

*rensfix _imp
rename *_imp  *

*Renaming 
foreach x of varlist hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag cwag swag ///
cheq prof extr bonu othe help plot opro spen ppen uif comp dis chld fost cdep indi inhe ///
rnt retr brid gift loan sale remt fwag_flg cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg ///
othe_flg help_flg plot_flg opro_flg spen_flg ppen_flg uif_flg comp_flg dis_flg chld_flg fost_flg ///
cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg remt_flg {
rename `x' w2_`x'
}

save "$DataOUT\temp.dta", replace

*************************
*Household level release*
*************************

use "$DataOUT\temp.dta", clear
keep w2_hhid w2_hhsizer w2_hhq_inc w2_hhq_incb w2_hhq_incb_flg w2_hhincome ///
w2_hhincome_flg w2_hhwage w2_hhgovt w2_hhother w2_hhinvest w2_hhcapital w2_hhremitt ///
w2_hhimprent w2_hhimprent_flg w2_hhagric w2_pi_hhincome w2_pi_hhwage w2_pi_hhgovt ///
w2_pi_hhother w2_pi_hhinvest w2_pi_hhcapital w2_pi_hhremitt w2_pi_hhagric w2_pi_hhimprent
sort w2_hhid
drop if w2_hhid==w2_hhid[_n-1]

sort w2_hhid
save "$DataOUT\release.dta", replace

**************************
*Individual level release*
**************************

use "$DataOUT\temp.dta", clear
keep pid w2_hhid w2_fwag w2_cwag w2_swag w2_cheq w2_prof w2_extr w2_bonu w2_othe ///
w2_help w2_plot w2_opro w2_spen w2_ppen w2_uif w2_comp w2_dis w2_chld w2_fost w2_cdep w2_indi w2_inhe ///
w2_rnt w2_retr w2_brid w2_gift w2_loan w2_sale w2_remt w2_fwag_flg w2_cwag_flg w2_swag_flg ///
w2_cheq_flg w2_prof_flg w2_extr_flg w2_bonu_flg w2_othe_flg w2_help_flg w2_plot_flg w2_opro_flg w2_spen_flg ///
w2_ppen_flg w2_uif_flg w2_comp_flg w2_dis_flg w2_chld_flg w2_fost_flg w2_cdep_flg w2_indi_flg ///
w2_inhe_flg w2_rnt_flg w2_retr_flg w2_brid_flg w2_gift_flg w2_loan_flg w2_sale_flg w2_remt_flg

order pid w2_hhid w2_fwag w2_cwag w2_swag w2_cheq w2_prof w2_extr w2_bonu w2_othe w2_help w2_plot w2_opro ///
w2_spen w2_ppen w2_uif w2_comp w2_dis w2_chld w2_fost w2_cdep w2_indi w2_inhe w2_rnt w2_retr ///
w2_brid w2_gift w2_loan w2_sale w2_remt w2_fwag_flg w2_cwag_flg w2_swag_flg w2_cheq_flg ///
w2_prof_flg w2_extr_flg w2_bonu_flg w2_othe_flg w2_help_flg w2_plot_flg w2_opro_flg w2_spen_flg w2_ppen_flg ///
w2_uif_flg w2_comp_flg w2_dis_flg w2_chld_flg w2_fost_flg w2_cdep_flg w2_indi_flg w2_inhe_flg ///
w2_rnt_flg w2_retr_flg w2_brid_flg w2_gift_flg w2_loan_flg w2_sale_flg w2_remt_flg

lab var w2_fwag "Monthly take home pay from primary and secondary jobs"
lab var w2_cwag "Monthly take home pay from casual work"
lab var w2_swag "Monthly income from self-employment"
lab var w2_cheq "Income from 13th cheque"
lab var w2_prof "Income from profit share"
lab var w2_extr "Monthly income from extra payment on a piece-rate basis"
lab var w2_bonu "Income from other bonuses from main job"
lab var w2_othe "Monthly income from other sources"
lab var w2_help "Monthly income from helping friends"
lab var w2_plot "Monthly income from subsistence agriculture on a plot" 
lab var w2_opro "Monthly value of own produce consumed"
lab var w2_ppen "Monthly income from private/foriegn penion pension and retirement annuities"
lab var w2_uif "Monthly income from UIF payments"
lab var w2_comp "Monthly income from workmen's compensation"
lab var w2_indi "Monthly income from interest and dividends"
lab var w2_inhe "Monthly income from inheritances"
lab var w2_rnt "Monthly income from rentals"
lab var w2_retr "Monthly income from retrenchment payments"
lab var w2_brid "Monthly income from lobola/bridal payments"
lab var w2_gift "Monthly income from gifts"
lab var w2_loan "Monthly 'income' from loan repayments"
lab var w2_sale "Monthly 'income' from sale of household assets"
lab var w2_remt "Monthly income from remittance payments"
lab var w2_fwag_flg "Net wage data flag"
lab var w2_cwag_flg "Casual wage data flag"
lab var w2_swag_flg "Self employment wage data flag"
lab var w2_cheq_flg "13th cheque data flag"
lab var w2_prof_flg "Profit share data flag"
lab var w2_extr_flg "Extra piece-rate payment data flag"
lab var w2_bonu_flg "Bonus income data flag"
lab var w2_othe_flg "Income from other sources data flag"
lab var w2_help_flg "Help income data flag"
lab var w2_plot_flg "Income from subsistence agriculture on a plot data flag"
lab var w2_opro_flg "Value of own produce consumed data flag"
lab var w2_ppen_flg "Private pension/retirement annuity data flag"
lab var w2_uif_flg "UIF income data flag"
lab var w2_comp_flg "Workmen's compensation data flag"
lab var w2_indi_flg "Interest and dividend income data flag"
lab var w2_inhe_flg "Inheritance income data flag"
lab var w2_rnt_flg "Rental income data flag"
lab var w2_retr_flg "Retrenchment income data flag"
lab var w2_brid_flg "Lobola/bridal income data flag"
lab var w2_gift_flg "Gift income data flag"
lab var w2_loan_flg "Loan repayment income data flag"
lab var w2_sale_flg "Sale of household assets data flag"
lab var w2_remt_flg "Remittance income data flag"

sort pid
save "$DataOUT\release_indiv.dta", replace

*********************
*Final release files*
*********************

clear
use "$DataOUT\temp.dta", clear
sort w2_hhid
merge m:1 w2_hhid using "$DataOUT\release.dta"
drop _merge
sort w2_hhid
drop if w2_hhid==w2_hhid[_n-1]
compress

keep w2_hhid w2_hhsizer w2_hhq_inc w2_hhq_incb w2_hhq_incb_flg w2_hhincome w2_hhincome_flg ///
w2_hhwage w2_hhgovt w2_hhother w2_hhinvest w2_hhcapital w2_hhremitt w2_hhimprent w2_hhimprent_flg ///
w2_pi_hhincome w2_pi_hhwage w2_pi_hhgovt w2_pi_hhother w2_pi_hhinvest w2_pi_hhcapital ///
w2_pi_hhremitt w2_pi_hhagric w2_hhagric w2_pi_hhimprent

order w2_hhid  /*w2_hhprov w2_hhgeo w2_hhdc w2_hhcluster w2_wgt w2_dwgt w2_wgt_p1 w2_dwgt_p1 w2_dtwgt_p1*/ ///
/*w2_dtwgt*/ w2_hhsizer w2_hhq_inc w2_hhq_incb w2_hhq_incb_flg w2_hhincome w2_hhincome_flg ///
w2_hhwage w2_hhgovt w2_hhother w2_hhinvest w2_hhcapital w2_hhremitt w2_hhimprent w2_hhimprent_flg ///
w2_hhagric w2_pi_hhincome w2_pi_hhwage w2_pi_hhgovt w2_pi_hhother w2_pi_hhinvest w2_pi_hhcapital ///
w2_pi_hhremitt w2_pi_hhagric w2_pi_hhimprent

lab var w2_hhq_incb_flg "The household income as per household questionnaire data for this individual is:"
lab var w2_hhagric "Household average monthly income from subsistence agriculture"

compress
duplicates drop w2_hhid, force

save "$DataOUT\hhderived_$VersionOUT", replace
erase "$DataOUT\temp.dta"

*Individual derived

use "$DataOUT\release_indiv.dta", clear
order pid w2_hhid
compress
save "$DataOUT\indderived_$VersionOUT", replace

erase "$DataOUT\data.dta"
capture erase "$DataOUT\temp.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\hhdata.dta"
erase "$DataOUT\release.dta"
erase "$DataOUT\release_indiv.dta"

* end of do file
*==================================================================================================================================================
